{$V-}

{

  Scrabble Game Editor v1.0 (c) Copyright 1990, Christopher Hall

  This is a BETA version of the Scrabble Game Editor.

  It requires Turbo Power's Object Professional to compile, as well as,
  the SDorDat.TPU file (Scrabble Default Types, etc).

  I include the source code primarily for example.

  Christopher Hall

}

Program sGamEdit;

{$I OPDEFINE.INC}

uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpColor,
  OpCrt,
  OpDate,
  OpAbsFld,
  OpCmd,
  OpField,
  OpFrame,
  OpWindow,
  OpSelect,
  OpEntry,
  SDorDat;

{Color set used by entry screen}
const
  EsColors : ColorSet = (
    TextColor       : LtCyanOnBlack;      TextMono        : YellowOnBlack;
    CtrlColor       : YellowOnBlue;       CtrlMono        : WhiteOnBlack;
    FrameColor      : DkGrayOnGreen;      FrameMono       : LtGrayOnBlack;
    HeaderColor     : LtGrayOnBlack;      HeaderMono      : BlackOnLtGray;
    ShadowColor     : DkGrayOnLtGray;     ShadowMono      : WhiteOnBlack;
    HighlightColor  : WhiteOnRed;         HighlightMono   : BlackOnLtGray;
    PromptColor     : DkGrayOnLtGray;     PromptMono      : LtGrayOnBlack;
    SelPromptColor  : DkGrayOnCyan;       SelPromptMono   : LtGrayOnBlack;
    ProPromptColor  : LtGrayOnBlue;       ProPromptMono   : LtGrayOnBlack;
    FieldColor      : LtGreenOnBlack;     FieldMono       : LtGrayOnBlack;
    SelFieldColor   : DkGrayOnCyan;       SelFieldMono    : WhiteOnBlack;
    ProFieldColor   : LtMagentaOnBlack;   ProFieldMono    : LtGrayOnBlack;
    ScrollBarColor  : DkGrayOnLtGray;     ScrollBarMono   : LtGrayOnBlack;
    SliderColor     : CyanOnBlue;         SliderMono      : WhiteOnBlack;
    HotSpotColor    : BlackOnCyan;        HotSpotMono     : BlackOnLtGray;
    BlockColor      : YellowOnCyan;       BlockMono       : WhiteOnBlack;
    MarkerColor     : WhiteOnCyan;        MarkerMono      : BlackOnLtGray;
    DelimColor      : YellowOnBlue;       DelimMono       : WhiteOnBlack;
    SelDelimColor   : DkGrayOnCyan;       SelDelimMono    : WhiteOnBlack;
    ProDelimColor   : YellowOnBlue;       ProDelimMono    : WhiteOnBlack;
    SelItemColor    : YellowOnCyan;       SelItemMono     : BlackOnLtGray;
    ProItemColor    : LtGrayOnBlue;       ProItemMono     : LtGrayOnBlack;
    HighItemColor   : WhiteOnBlue;        HighItemMono    : WhiteOnBlack;
    AltItemColor    : WhiteOnBlue;        AltItemMono     : WhiteOnBlack;
    AltSelItemColor : WhiteOnCyan;        AltSelItemMono  : BlackOnLtGray;
    FlexAHelpColor  : WhiteOnBlue;        FlexAHelpMono   : WhiteOnBlack;
    FlexBHelpColor  : WhiteOnBlue;        FlexBHelpMono   : WhiteOnBlack;
    FlexCHelpColor  : LtCyanOnBlue;       FlexCHelpMono   : BlackOnLtGray;
    UnselXrefColor  : YellowOnBlue;       UnselXrefMono   : LtBlueOnBlack;
    SelXrefColor    : WhiteOnCyan;        SelXrefMono     : BlackOnLtGray;
    MouseColor      : WhiteOnRed;         MouseMono       : BlackOnLtGray
  );

{Frame & Window Option Constants}
const
  Frame1 = 'зĺ';
  WinOptions = wBordered+wClear+wUserContents;

{Entry field constants}
const
  idOpenGame             = 0;
  idNoPlayers            = idOpenGame+1;
  idBeingPlayed          = idNoPlayers+1;
  idTotalScore           = idBeingPlayed+1;
  idCompleted            = idTotalScore+1;
  idEmptyHands           = idCompleted+1;
  idDateComp             = idEmptyHands+1;
  idRemovedPts           = idDateComp+1;
  idTiles1               = idRemovedPts+1;
  idTiles2               = idTiles1+1;
  idPlayer1              = idTiles2+1;
  idPlayer2              = idPlayer1+1;
  idPlayer3              = idPlayer2+1;
  idPlayer4              = idPlayer3+1;
  idWhosTurn             = idPlayer4+1;
  idPlayNumber           = idWhosTurn+1;
  idGridWords            = idPlayNumber+1;
  idLetterGrid           = idGridWords+1;

var
  ESDone, Finished : boolean;
  ES       : EntryScreen;
  ESPlayer : EntryScreen;
  ESLetter : EntryScreen;
  SESGrid  : ScrollingEntryScreen;
  ESBoard  : EntryScreen;
  UR       : GameRecord;
  Status   : Word;
  sGameF   : FILE of GameRecord;
  Tiles1,
  Tiles2   : string[50];
  aHand    : array[1..7] of char;
  x        : word;
  Player_Scratch  : PlayRec;
  Grid_Scratch    : array[1..MaxGridWords] of WordValue;

{$F+}
procedure PreEdit(ESP : EntryScreenPtr);
  {-Called just before a field is edited}
begin
end;

procedure PostEdit(ESP : EntryScreenPtr);
  {-Called just after a field has been edited}
begin
  with ESP^ do
    case GetCurrentID of
      idOpenGame      :;
      idBeingPlayed   :;
      idCompleted     :;
      idDateComp      :;
      idTiles1,idTiles2 : UR.Tiles := Tiles1+Tiles2;
      idWhosTurn      :;
      idNoPlayers     :;
      idTotalScore    :;
      idEmptyHands    :;
      idPlayNumber    :;
      idRemovedPts    :;
      idPlayer1       :;
      idPlayer2       :;
      idPlayer3       :;
      idPlayer4       :;
      idGridWords     :;
      idLetterGrid    :;
    end;
end;

{$F-}

function InitEntryScreen : Word;
begin
  with ES do begin
    if not InitCustom(3, 4, 78, 21, EsColors, WinOptions) then begin
      InitEntryScreen := InitStatus;
      Exit;
    end;

    wFrame.SetFrameType(Frame1);
    EnableExplosions(5);
    wFrame.AddShadow(shBR, shOverWrite);
    wFrame.AddHeaderColor('  Scrabble Game Editor v1.0  ', heTC, $07, $70);
    esOptionsOn(esScrollByPage);
    esOptionsOff(esMousePage);
    esFieldOptionsOn(efClearFirstChar+efRequired+efTrimBlanks);
    SetWrapMode(WrapAtEdges);

    SetPreEditProc(PreEdit);
    SetPostEditProc(PostEdit);

  {idOpenGame:}
    AddBooleanField(
      'Open Game     : ', 1, 1, 
      'B', 1, 18, 
      1, UR.OpenGame);

  {idNoPlayers:}
    AddIntField(
      'Number of Players: ', 1, 53,
      '9', 1, 73,
      2, 0, 4, UR.NoPlayers);

  {idBeingPlayed:}
    AddBooleanField(
      'Being Played  : ', 2, 1, 
      'B', 2, 18, 
      3, UR.BeingPlayed);

  {idTotalScore:}
    esFieldOptionsOn(efProtected);
    AddIntField(
      'Total Score      : ', 2, 53,
      '9999', 2, 73,
      4, 0, 9999, UR.TotalScore);
    esFieldOptionsOff(efProtected);

  {idCompleted:}
    AddBooleanField(
      'Completed     : ', 3, 1, 
      'B', 3, 18, 
      5, UR.Completed);

  {idEmptyHands:}
    AddIntField(
      'Empty Hands      : ', 3, 53,
      '99', 3, 73,
      6, 0, 99, UR.EmptyHands);

  {idDateComp:}
    AddDateField(
      'Date Complete : ', 4, 1, 
      'mm/dd/yy', 4, 18, 
      7, MinDate, MaxDate, UR.DateComp);

  {idRemovedPts:}
    AddIntField(
      'Removed Points   : ', 4, 53,
      '999', 4, 73,
      8, 0, 999, UR.RemovedPts);

  {idTiles:}
    SetForceMode(True, True);
    esFieldOptionsOff(efInsertPushes+efClearFirstChar+efRequired);
    AddStringField(
      'Tiles (1-50)  : ', 6, 1,
      CharStr('!', 50), 6, 18, 50,
      9, Tiles1);

    AddStringField(
      'Tiles (51-100): ', 7, 1,
      CharStr('!', 50), 7, 18, 50,
      9, Tiles2);

  {idPlayer1:}
    AddNestedStringField(
      'Player 1 : ', 9, 1,
      CharStr('a', 25), 9, 13, 25,
      11, UR.Players[1].Name);

  {idPlayer2:}
    AddNestedStringField(
      'Player 2 : ', 10, 1,
      CharStr('a', 25), 10, 13, 25,
      11, UR.Players[2].Name);

  {idPlayer3:}
    AddNestedStringField(
      'Player 3 : ', 11, 1,
      CharStr('a', 25), 11, 13, 25,
      11, UR.Players[3].Name);

  {idPlayer4:}
    AddNestedStringField(
      'Player 4 : ', 12, 1,
      CharStr('a', 25), 12, 13, 25,
      11, UR.Players[4].Name);

  {idWhosTurn:}
    AddStringField(
      'Who''s Turn : ', 14, 1, 
      CharStr('a', 25), 14, 16, 25,
      15, UR.WhosTurn);
    esFieldOptionsOn(efRequired);

  {idPlayNumber:}
    AddIntField(
      'Play Number: ', 16, 1, 
      '999', 16, 16,
      16, 0, 999, UR.PlayNumber);

  {idGridWords:}
  esFieldOptionsOff(efRequired);
    AddNestedField(
      'History List: ', 16, 30,
      'X', 16, 45, 1, 17);
  esFieldOptionsOn(efRequired);

  {idLetterGrid:}
  esFieldOptionsOff(efRequired);
    AddNestedField(
      'Game Board: ', 16, 55,
      'X', 16, 70, 1, 18);
  esFieldOptionsOn(efRequired);

    AddTextField('<Ctrl-Enter> - Save & Exit  <Esc> - Quits ', 18, 20);

    InitEntryScreen := RawError;
  end;
end;

function InitPlayerScreen : Word;
begin
  with ESPlayer do begin
    if not InitCustom(20, 8, 60, 18, EsColors, WinOptions) then begin
      InitPlayerScreen := InitStatus;
      Exit;
    end;

    wFrame.SetFrameType(Frame1);
    EnableExplosions(5);
    wFrame.AddShadow(shBR, shOverWrite);
    wFrame.AddHeaderColor('  Player Entry Screen  ', heTC, $07, $70);
    esFieldOptionsOn(efClearFirstChar);
    esFieldOptionsOff(efRequired);
    SetWrapMode(StopAtEdges);

    SetPreEditProc(PreEdit);
    SetPostEditProc(PostEdit);

    AddStringField(
      'Player Name: ', 2, 1,
      CharStr('a', 25), 2, 16, 25,
      1, Player_Scratch.Name);

    esFieldOptionsON(efProtected);
    AddStringField(
      'Last Date  : ', 3, 1,
      CharStr('X',20), 3, 16, 20,
      2, Player_Scratch.Date);
    esFieldOptionsOff(efProtected);

     AddByteField(
       'Total Moves: ', 4, 1,
       '999', 4, 16,
       3, 0, 255, Player_Scratch.Moves);

     AddIntField(
       'Score      : ', 5, 1,
       '999', 5, 16,
       4, 0, 999, Player_Scratch.Score);

     AddBooleanField(
       'Winner     : ', 6, 1,
       'B', 6, 16,
       5, Player_Scratch.Win);

     AddBooleanField(
       'Passed     : ', 7, 1,
       'B', 7, 16,
       5, Player_Scratch.Passed);

     AddBooleanField(
       'Vote       : ', 8, 1,
       'B', 8, 16,
       5, Player_Scratch.Vote);

     esFieldOptionsOff(efClearFirstChar+efInsertPushes);
     AddArrayField(
       'Hand       : ', 9, 1,
       '!!!!!!!', 9, 16,
       7, 6, aHand);
     esFieldOptionsOn(efClearFirstChar+efInsertPushes);

     AddTextField('<Ctrl-Enter> - Save   <Esc> - Quits', 11, 3);

    InitPlayerScreen := RawError;

  end;
end;

function EditGridWords : boolean;
var
  x, Status : word;
  AllDone : boolean;
begin
  with SESGrid do
  begin
    if not InitCustom(3, 4, 78, 21, EsColors, WinOptions) then
    begin
      Writeln('Failed to init EntryScreen.  Status = ', InitStatus);
      Halt;
    end;
    wFrame.SetFrameType(Frame1);
    EnableExplosions(5);
    wFrame.AddShadow(shBR, shOverWrite);
    wFrame.AddHeaderColor('  History List Entry Screen  ', heTC, $07, $70);
    esFieldOptionsOn(efClearFirstChar);
    esFieldOptionsOff(efInsertPushes+efRequired);
    SetWrapMode(StopAtEdges);

    AddTextField  (' #      Word         Val       Player                   X1  X2  Y1  Y2' , 1, 1);
    AddTextField  ('-----------------------------------------------------------------------', 2, 1);

    for x := 1 to MaxGridWords do
    begin
      AddByteField  ('', x+2, 1,  '99'                       , x+2, 2,  0,   0, 99,   Grid_Scratch[x].PlayNum);
      AddStringField('', x+2, 4,  '!!!!!!!!!!!!!!!'          , x+2, 5,  15,  0,       Grid_Scratch[x].GridWord);
      AddIntField   ('', x+2, 21, '99'                       , x+2, 22, 0,   0, 99,   Grid_Scratch[x].GridWordValue);
      AddStringField('', x+2, 28, 'aaaaaaaaaaaaaaaaaaaaaaaaa', x+2, 29, 25,  0,       Grid_Scratch[x].WhosWord);
      AddByteField  ('', x+2, 56,  '99'                       , x+2, 57,  0, 0, 15,   Grid_Scratch[x].x1);
      AddByteField  ('', x+2, 60,  '99'                       , x+2, 61,  0, 0, 15,   Grid_Scratch[x].x2);
      AddByteField  ('', x+2, 64,  '99'                       , x+2, 65,  0, 0, 15,   Grid_Scratch[x].y1);
      AddByteField  ('', x+2, 68,  '99'                       , x+2, 69,  0, 0, 15,   Grid_Scratch[x].y2);
    end;

    AllocateScreen;
    Status := GetLastError;
    if Status <> 0 then
    begin
      Writeln('Error ', Status, ' creating entry screen');
      Halt;
    end;

    AllDone := false;
    repeat
      Process;
      if GetLastCommand <> ccQuit then
      for x := 1 to MaxGridWords do
        UR.GridWords[x] := Grid_Scratch[x];

      case GetLastCommand of
        ccError,
        ccExitAtTop,
        ccExitAtBot,
        ccNextRec,
        ccPrevRec,
        ccQuit,
        ccDone : begin
                   AllDone := True;
                   EditGridWords := (GetLastCommand <> ccPrevRec) and
                                    (GetLastCommand <> ccExitAtTop);
                 end;
      end;
    until AllDone;
    Erase;
    Done;
  end;
end;

function EditPlayer(CurrID : byte) : boolean;
var
  x : byte;
  AllDone : boolean;
begin
  for x := 1 to 7 do
  begin
    if Player_Scratch.Hand[x] <> '' then
      aHand[x] := Player_Scratch.Hand[x][1]
    else
      aHand[x] := '#';
  end;

  with ESPlayer do
  begin
    AllDone := false;
    repeat
      Process;

      if GetLastCommand <> ccQuit then
      begin
        for x := 1 to 7 do
        begin
          if aHand[x] <> '#' then
            Player_Scratch.Hand[x] := aHand[x]
          else
            Player_Scratch.Hand[x] := '';
        end;
        UR.Players[CurrID] := Player_Scratch;
      end;

      case GetLastCommand of
        ccError,
        ccExitAtTop,
        ccExitAtBot,
        ccNextRec,
        ccPrevRec,
        ccQuit,
        ccDone :
          begin
            AllDone := True;
            EditPlayer := (GetLastCommand <> ccPrevRec) and
                          (GetLastCommand <> ccExitAtTop);
          end;
      end;
    until AllDone;
    Erase;
  end;
end;

function EditGameBrd : boolean;
var
  x, y : word;
  AllDone : boolean;
  Brd_Scratch : array[1..15,1..15] of string[1];
begin
  for x := 1 to 15 do
  for y := 1 to 15 do
    Brd_Scratch[x,y] := Game.LetterGrid[x,y].Tile;

  with ESBoard do begin
    if not InitCustom(15, 3, 65, 20, EsColors, WinOptions) then begin
      EditGameBrd := false;
      Exit;
    end;

    wFrame.SetFrameType(Frame1);
    EnableExplosions(5);
    wFrame.AddShadow(shBR, shOverWrite);
    wFrame.AddHeaderColor('  Game Board Entry Screen  ', heTC, $07, $70);
    esFieldOptionsOff(efClearFirstChar+efRequired);
    SetWrapMode(StopAtEdges);

    SetPreEditProc(PreEdit);
    SetPostEditProc(PostEdit);

    for x := 1 to 15 do
    for y := 1 to 15 do
      AddStringField(
        '',  x+1,   (3*y),
        'A', x+1,   (3*y)+1, 1, 0, Brd_Scratch[x,y]);

    AddTextField('<Ctrl-Enter> - Save & Exit  <Esc> - Quits ', 18, 6);

    SetNextField(112);

    AllDone := false;
    repeat
      Process;
      if GetLastCommand <> ccQuit then
        for y := 1 to 15 do
        for x := 1 to 15 do
          Game.LetterGrid[x,y].Tile := Brd_Scratch[x,y];

      case GetLastCommand of
        ccError,
        ccExitAtTop,
        ccExitAtBot,
        ccNextRec,
        ccPrevRec,
        ccQuit,
        ccDone :
          begin
            AllDone := True;
            EditGameBrd := (GetLastCommand <> ccPrevRec) and
                           (GetLastCommand <> ccExitAtTop);
          end;
      end;

    until AllDone;
    Erase;
    Done;
  end;
end;

{*** Main Code Segment follows ***}

begin
  Finished := false;
  ESDone := false;
  assign(sGameF,'Scrabble.Gam');
  {$I-}
  reset(sGameF);
  {$I+}
  if IOResult <> 0 then
  begin
    writeln('Cannot locate Scrabble.Gam file!');
    Halt;
  end;
  if NOT EOF(sGameF) then read(sGameF, Game);
  repeat
    ClrScr;
    writeln('Scrabble Game Editor v1.0  -  Christopher Hall');
    writeln;
    writeln('Games in File: ',FileSize(sGameF),'    Current Game: ',FilePos(sGameF));
    writeln;
    write('<E>dit/View   <N>ext   <P>revious   <Q>uit : ');
    repeat
      Selection := UpCase(ReadKey);
    until (Selection in ['E','N','P','Q', #27]);
    case Selection of
      'E' : begin
              ClrScr;

              {Initialize Main Entry Screen}
              Status := InitEntryScreen;
              if Status <> 0 then begin
                WriteLn('Error initializing entry screen: ', Status);
                Halt(1);
              end;
              ES.SetBeepOnError(Off);

              {Initialize Player Entry Screen}
              Status := InitPlayerScreen;
              if Status <> 0 then begin
                Writeln('Error initializing Player Entry Screen: ', Status);
                Halt(1);
              end;
              ESPlayer.SetBeepOnError(Off);

              {initialize user record}

              UR.OpenGame    := Game.OpenGame;
              UR.BeingPlayed := Game.BeingPlayed;
              UR.Completed   := Game.Completed;
              UR.DateComp    := Game.DateComp;
              UR.Tiles       := Game.Tiles;
              Tiles1         := Copy(UR.Tiles,1,50);
              Tiles2         := Copy(UR.Tiles,51,100);
              UR.WhosTurn    := Game.WhosTurn;
              UR.Players     := Game.Players;
              UR.NoPlayers   := Game.NoPlayers;
              UR.TotalScore  := Game.TotalScore;
              UR.EmptyHands  := Game.EmptyHands;
              UR.RemovedPts  := Game.RemovedPts;
              UR.PlayNumber  := Game.PlayNumber;
              UR.LetterGrid  := Game.LetterGrid;
              UR.GridWords   := Game.GridWords;

              { ***  Main Entry Screen  *** }

              with ES do
              begin
                ESDone := false;
                repeat
                  Process;
                  case GetLastCommand of
                    ccQuit   : ESDone := true;
                    ccNested : begin
                                 case GetCurrentId of
                                   idPlayer1 : begin
                                                 Player_Scratch := Game.Players[1];
                                                 if EditPlayer(1) then
                                                   SetNextField(idPlayer2)
                                                 else
                                                   SetNextField(idRemovedPts);
                                               end;
                                   idPlayer2 : begin
                                                 Player_Scratch := Game.Players[2];
                                                 if EditPlayer(2) then
                                                   SetNextField(idPlayer3)
                                                 else
                                                   SetNextField(idPlayer1);
                                               end;
                                   idPlayer3 : begin
                                                 Player_Scratch := Game.Players[3];
                                                 if EditPlayer(3) then
                                                   SetNextField(idPlayer4)
                                                 else
                                                   SetNextField(idPlayer2);
                                               end;
                                   idPlayer4 : begin
                                                 Player_Scratch := Game.Players[4];
                                                 if EditPlayer(4) then
                                                   SetNextField(idWhosTurn)
                                                 else
                                                   SetNextField(idPlayer3);
                                               end;
                                   idGridWords : begin
                                                   for x := 1 to MaxGridWords do
                                                     Grid_Scratch[x] := Game.GridWords[x];
                                                   if EditGridWords then
                                                     SetNextField(0)
                                                   else
                                                     SetNextField(idPlayNumber);
                                                 end;
                                   idLetterGrid: begin
                                                   if EditGameBrd then
                                                     SetNextField(0)
                                                   else
                                                     SetNextField(idGridWords);
                                                 end;
                                 end;
                               end;
                    ccDone : begin
                               Game.OpenGame    := UR.OpenGame;
                               Game.BeingPlayed := UR.BeingPlayed;
                               Game.Completed   := UR.Completed;
                               Game.DateComp    := UR.DateComp;
                               Game.Tiles       := UR.Tiles;
                               Game.WhosTurn    := UR.WhosTurn;
                               Game.Players     := UR.Players;
                               Game.NoPlayers   := UR.NoPlayers;
                               Game.TotalScore  := UR.TotalScore;
                               Game.EmptyHands  := UR.EmptyHands;
                               Game.RemovedPts  := UR.RemovedPts;
                               Game.PlayNumber  := UR.PlayNumber;
                               Game.LetterGrid  := UR.LetterGrid;
                               Game.GridWords   := UR.GridWords;

                               seek(sGameF, FilePos(sGameF)-1);
                               write(sGameF, Game);
                               ESDone := true;
                             end;
                    ccError: begin
                               writeln('An Error Has Occurred!');
                               Halt(1);
                             end;
                  end;
                until ESDone;
                Erase;
                Done;
              end;
            end;
      'N' : begin
              if EOF(sGameF) then
                seek(sGameF, 0);
              read(sGameF, Game)
            end;
      'P' : begin
              if (FilePos(sGameF) > 1) then
              begin
                seek(sGameF, FilePos(sGameF)-2);
                read(sGameF, Game);
              end;
            end;
      'Q', #27 : begin
                   Finished := true;
                   Close(sGameF);
                 end;
    end; {Case}
  until Finished;
end.
